/* 
 *  UUITabBase.java
 * 
 *  Copyright 2016 Avaya Inc. All Rights Reserved.
 * 
 *  Usage of this source is bound to the terms described
 *  in AvayaLicenseSDK.rtf.
 * 
 *  Avaya - Confidential & Proprietary. Use pursuant to your signed agreement
 *  or Avaya Policy
 * 
 */
package com.avaya.ccs.javafxrefclient;

import javafx.scene.control.Tab;
import javafx.scene.control.TextArea;
import javafx.scene.layout.BorderPane;

public class UUITabBase {

    protected final Tab tab;
    protected final TextArea uuiEditor;
    protected final String BLANKUUI = "no UUI to display";
    protected final BorderPane uuiPane;
    private static final Logger LOG = Logger.getLogger(UUITabBase.class);

    public UUITabBase() {
        uuiEditor = new TextArea();
        uuiEditor.getStyleClass().add("uuiEditor");
        uuiEditor.setText(BLANKUUI);
        uuiEditor.setDisable(true);
        tab = new Tab();
        tab.setText("UUI");
        tab.setClosable(false);
        tab.setContent(uuiEditor);
        tab.setDisable(true);

        uuiPane = new BorderPane();
        uuiPane.setCenter(uuiEditor);
        tab.setContent(uuiPane);
    }

    public Tab getTab() {
        return tab;
    }
    
    void update(InteractionDataI data) {
        String methodName = "update() ";
        LOG.trace(methodName + "+");

        boolean disable = !data.canGetUUI();
        LOG.trace(methodName + "disable = " + disable);
        this.tab.setDisable(false);
        this.uuiEditor.setDisable(disable);

        String uuiData = data.getUui();
        if (uuiData != null) {
            LOG.trace(methodName + "UUI:" + uuiData);
            uuiEditor.setText(uuiData);
        } else {
            LOG.trace(methodName + "setting blank txt");
            uuiEditor.setText(BLANKUUI);
        }
        LOG.trace(methodName + "-");
    }

}
